#include "pch.h"

#include "FTNStruc.hpp"
#include "Links.h"


/*******
  CLink
 *******/


CLink::CLink() 
: name(),
  password(),
  activity(ACTIVITY_USUAL),
  outboundType(OT_BINKLEY),
  flavourType(FT_NORMAL),
  sendPriority(0),
  receivePriority(0),
  groups(),
  allowAreaCreationFlag(),
  autoCreatedPathName(),
  defaultGroup(),
  autocreatedSendPriority(0),
  autocreatedReceivePriority(0),
  availAreasFileName(),
  robotName(),
  akaSpecified(false)
 {

	ourAddress      = g_vars.m_addrMain;
}


bool CLink::canAccessGroup(const tstring& groupName) const {
	VTString::const_iterator	it = groups.begin();
	while (it != groups.end()) {
		if (lstrcmpi((*it).c_str(), groupName.c_str() ) == 0) {
			return true;
		}
		it++;
	}

	return false;
}


bool CLink::removeGroup(const tstring& groupName) {
	VTString::iterator	it = groups.begin();
	while (it != groups.end()) {
		if (lstrcmpi((*it).c_str(), groupName.c_str() ) == 0) {
			groups.erase( it );
			return true;
		}
		it++;
	}

	return false;
}


tstring CLink::getFileBoxPath() const {
	CommonDataPtr	commonData = CCommonData::getInstance();
	tstring	path = commonData->getFileBoxesPath();

	assert( path.size() > 0 );

	TCHAR	buffer[64];
	int		len;
	if (commonData->areLongFileBoxes()) {
		// zone.net.node.point
		_stprintf( buffer, TEXT("%hu.%hu.%hu.%hu"), address.Zone, address.Net, address.Node, address.Point );
		path += buffer;
		if (flavourType == FT_HOLD) {
			path += TEXT(".H");
		}
	} else {
		// zznnnfff.pp

		tstring	name;

		// zz

		_itot( address.Zone, buffer, 32 );
		len = lstrlen( buffer );
		while (len < 2) {
			name += TEXT('0');
			++len;
		}
		name += buffer;

		// nnn

		_itot( address.Net, buffer, 32 );
		len = lstrlen( buffer );
		while (len < 3) {
			name += TEXT('0');
			++len;
		}
		name += buffer;

		// fff

		_itot( address.Node, buffer, 32 );
		len = lstrlen( buffer );
		while (len < 3) {
			name += TEXT('0');
			++len;
		}
		name += buffer;

		name += TEXT('.');

		// pp

		_itot( address.Point, buffer, 32 );
		len = lstrlen( buffer );
		while (len < 2) {
			name += TEXT('0');
			++len;
		}
		name += buffer;

		if (flavourType == FT_HOLD) {
			name += TEXT('H');
		}

		lstrcpy( buffer, name.c_str() );
		path += _tcsupr( buffer );
	}

	return path;
}
